<?php
include 'koneksi.php';
session_start();

// Proteksi halaman
if (!isset($_SESSION['username'])) {
    header("location: index.php");
    exit();
}

if (isset($_POST['simpan'])) {
    $nama    = mysqli_real_escape_string($koneksi, $_POST['nama']);
    $email   = mysqli_real_escape_string($koneksi, $_POST['email']);
    $telp    = mysqli_real_escape_string($koneksi, $_POST['telepon']);
    $layanan = mysqli_real_escape_string($koneksi, $_POST['jenis_layanan']);
    $keluhan = mysqli_real_escape_string($koneksi, $_POST['keluhan']);
    $status  = $_POST['status'];

    $query = "INSERT INTO pelanggan (nama, email, telepon, jenis_layanan, keluhan, status) 
              VALUES ('$nama', '$email', '$telp', '$layanan', '$keluhan', '$status')";
    
    if (mysqli_query($koneksi, $query)) {
        echo "<script>alert('Data Berhasil Disimpan!'); window.location='data.php';</script>";
    } else {
        echo "Error: " . mysqli_error($koneksi);
    }
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <title>Tambah Pelanggan</title>
    <style>
        body {
            margin: 0;
            font-family: 'Segoe UI', sans-serif;
            background: linear-gradient(to bottom right, #63473e, #b5a4a1);
            height: 100vh;
            display: flex;
            justify-content: center;
            align-items: center;
        }

        .form-container {
            background-color: white;
            width: 400px;
            padding: 40px;
            border-radius: 25px;
            box-shadow: 0 15px 35px rgba(0,0,0,0.2);
            text-align: center;
        }

        .form-container h2 {
            color: #4a342e;
            margin-bottom: 25px;
            font-weight: bold;
        }

        input, select, textarea {
            width: 100%;
            padding: 12px;
            margin-bottom: 15px;
            border: 1px solid #d1d9e0;
            border-radius: 10px;
            background-color: #f0f4f8; /* Warna biru muda lembut seperti di gambar */
            box-sizing: border-box;
            font-size: 14px;
        }

        textarea { resize: none; }

        .btn-simpan {
            width: 100%;
            padding: 12px;
            background-color: #63473e;
            color: white;
            border: none;
            border-radius: 10px;
            cursor: pointer;
            font-weight: bold;
            font-size: 16px;
            transition: background 0.3s;
        }

        .btn-simpan:hover {
            background-color: #4a342e;
        }

        .btn-kembali {
            display: inline-block;
            margin-top: 15px;
            text-decoration: none;
            color: #666;
            font-size: 14px;
        }

        .btn-kembali:hover { text-decoration: underline; }
    </style>
</head>
<body>

    <div class="form-container">
        <h2>Tambah Pelanggan</h2>
        <form method="POST" action="">
            <input type="text" name="nama" placeholder="yunila sari" required>
            <input type="email" name="email" placeholder="lasariyuni89@gmail.com" required>
            <input type="text" name="telepon" placeholder="083816771913" required>
            <input type="text" name="jenis_layanan" placeholder="informasi" required>
            <textarea name="keluhan" rows="3" placeholder="gatau" required></textarea>
            
            <select name="status">
                <option value="Pending">Baru</option>
                <option value="Proses">Sedang Diproses</option>
                <option value="Selesai">Selesai</option>
            </select>

            <button type="submit" name="simpan" class="btn-simpan">Simpan</button>
            <a href="dashboard.php" class="btn-kembali">← Kembali</a>
        </form>
    </div>

</body>
</html>