<?php
include 'koneksi.php';
session_start();

// Ambil data dari tabel pelanggan
$query = "SELECT * FROM pelanggan ORDER BY id DESC";
$result = mysqli_query($koneksi, $query);
?>

<!DOCTYPE html>
<html>
<head>
    <title>Data Pelanggan</title>
    <style>
        body { background: linear-gradient(to bottom right, #63473e, #b5a4a1); font-family: 'Segoe UI', sans-serif; padding: 40px; margin: 0; min-height: 100vh; }
        .container { background: white; padding: 30px; border-radius: 20px; max-width: 1000px; margin: auto; box-shadow: 0 15px 35px rgba(0,0,0,0.2); }
        .header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        h2 { color: #4a342e; margin: 0; }
        table { width: 100%; border-collapse: collapse; margin-top: 10px; }
        th { background: #4a342e; color: white; padding: 15px; text-align: center; }
        td { padding: 12px; border-bottom: 1px solid #eee; text-align: center; font-size: 14px; }
        tr:hover { background-color: #f9f9f9; }
        .btn-back { text-decoration: none; color: white; font-weight: bold; font-size: 14px; margin-bottom: 10px; display: inline-block; }
        .status-badge { background: #63473e; color: white; padding: 5px 10px; border-radius: 8px; font-weight: bold; font-size: 12px; }
    </style>
</head>
<body>
    <a href="dashboard.php" class="btn-back">← Kembali ke Dashboard</a>
    <div class="container">
        <div class="header">
            <h2>📋 Daftar Keluhan Pelanggan</h2>
        </div>
        <table>
            <thead>
                <tr>
                    <th>No</th>
                    <th>Nama</th>
                    <th>Email</th>
                    <th>Telepon</th>
                    <th>Layanan</th>
                    <th>Keluhan</th>
                    <th>Status</th>
                    <th>Aksi</th>
                </tr>
            </thead>
            <tbody>
                <?php 
                $no = 1;
                if ($result && mysqli_num_rows($result) > 0) {
                    while($row = mysqli_fetch_assoc($result)) { ?>
                    <tr>
                        <td><?= $no++; ?></td>
                        <td><b><?= $row['nama']; ?></b></td>
                        <td><?= $row['email']; ?></td>
                        <td><?= $row['telepon']; ?></td>
                        <td><?= $row['jenis_layanan']; ?></td>
                        <td><?= $row['keluhan']; ?></td>
                        <td><span class="status-badge"><?= $row['status']; ?></span></td>
                        <td>
                            <a href="edit.php?id=<?= $row['id']; ?>" style="color: #2980b9; text-decoration: none; font-weight: bold;">Edit</a> | 
                            <a href="hapus.php?id=<?= $row['id']; ?>" style="color: #c0392b; text-decoration: none; font-weight: bold;" onclick="return confirm('Hapus data ini?')">Hapus</a>
                        </td>
                    </tr>
                <?php } 
                } else {
                    echo "<tr><td colspan='8'>Belum ada data pelanggan.</td></tr>";
                } ?>
            </tbody>
        </table>
    </div>
</body>
</html>