<?php
session_start();
// Cek apakah sudah login, kalau belum tendang ke index.php
if (!isset($_SESSION['username'])) {
    header("location: index.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard Layanan Pelanggan</title>
    <style>
        /* Mengatur background gradasi cokelat seperti di gambar */
        body {
            margin: 0;
            padding: 0;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
            background: linear-gradient(to right, #63473e, #b5a4a1);
            height: 100vh;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            color: white;
        }

        .header {
            text-align: center;
            margin-bottom: 40px;
        }

        .header h1 {
            font-size: 2.5rem;
            margin-bottom: 5px;
        }

        .header p {
            font-size: 1.1rem;
            opacity: 0.9;
        }

        /* Container untuk kartu-kartu */
        .card-container {
            display: flex;
            gap: 30px;
            margin-bottom: 30px;
        }

        /* Styling Kartu Putih */
        .card {
            background-color: white;
            width: 220px;
            height: 220px;
            border-radius: 20px;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            text-decoration: none;
            color: #333;
            font-weight: bold;
            font-size: 1.1rem;
            box-shadow: 0 10px 20px rgba(0,0,0,0.2);
            transition: transform 0.3s ease, box-shadow 0.3s ease;
        }

        .card:hover {
            transform: translateY(-10px);
            box-shadow: 0 15px 30px rgba(0,0,0,0.3);
        }

        /* Ikon di dalam kartu */
        .icon {
            font-size: 60px;
            margin-bottom: 15px;
        }

        /* Tombol Logout */
        .logout-btn {
            color: #f1ede8;
            text-decoration: none;
            font-weight: bold;
            font-size: 0.9rem;
            display: flex;
            align-items: center;
            gap: 5px;
            opacity: 0.8;
            transition: opacity 0.3s;
        }

        .logout-btn:hover {
            opacity: 1;
            text-decoration: underline;
        }
    </style>
</head>
<body>

    <div class="header">
        <h1>☕ Dashboard Layanan Pelanggan</h1>
        <p>Sistem Informasi Pelayanan</p>
    </div>

    <div class="card-container">
        <a href="tambah.php" class="card">
            <div class="icon" style="color: #8e44ad;">➕</div>
            <span>Tambah Pelanggan</span>
        </a>

        <a href="data.php" class="card">
            <div class="icon" style="color: #d35400;">📋</div>
            <span>Data Pelanggan</span>
        </a>
    </div>

    <a href="logout.php" class="logout-btn">
        🚪 Logout
    </a>

</body>
</html>